import java.rmi.*;
import java.util.Date;

/**
 * Interfaccia contenente i metodi del server invocabili in remoto
 * dal client del newsgroup
 *  
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 * 
 */
public interface INewsgroupServer extends Remote{
	
	/**
	 * Metodo che permette al cliente di registrarsi sul server per 
	 * la successiva callback
	 * @param client_ref il riferimento al client
	 * @throws RemoteException
	 */
	public void registerNews(INewsgroupClient client_ref)throws RemoteException;
	
	/**
	 * Metodo che permette al cliente di cancellare la propria 
	 * registrazione sul server
	 * @param client_ref riferimento al client
	 * @throws RemoteException
	 */
	public void unregisterNews(INewsgroupClient client_ref)throws RemoteException;
	
	/**
	 * Metodo che permette la lettura in remoto di messaggi
	 * sulla bacheca elettronica dato l'oggetto di un messaggio di interesse
	 * Usa una callback per comunicare con il cliente remoto
	 * @param client_ref riferimento al cliente remoto
	 * @param obj oggetto dei messagi di interesse
	 * @throws RemoteException
	 */
	public void read(INewsgroupClient client_ref,String obj)throws RemoteException;
	
	/**
	 * Metodo che permette la lettura in remoto di messaggi
	 * sulla bacheca elettronica, dato l'oggetto e il mittente di un messaggio 
	 * di interesse. Usa una callback per comunicare con il cliente remoto
	 * @param client_ref riferimento al cliente remoto
	 * @param sender mittente di cui si vuole trovare i messaggi
	 * @param obj oggetto dei messagi di interesse
	 * @throws RemoteException
	 */
	public void read(INewsgroupClient client_ref,Person sender,String obj)
					throws RemoteException;
	
	/**
	 * Metodo che permette la lettura in remoto di messaggi
	 * sulla bacheca elettronica, messaggi caratterizzati che sono, 
	 * oltre che dall'oggetto e dal mittente, anche da una data di invio. 
	 * Usa una callback per comunicare con il cliente remoto
	 * @param client_ref riferimento al cliente remoto
	 * @param sender mittente di cui si vuole trovare i messaggi
	 * @param obj oggetto dei messagi di interesse
	 * @param date data del/i messaggio/i che si sta/stanno cercando
	 * @throws RemoteException
	 */
	public void read(INewsgroupClient client_ref,Person sender,String obj,Date time)
				throws RemoteException;
	
	/**
	 * Metodo che permette la lettura di tutti i messaggi che non sono risposta 
	 * di altri
	 * @param client_ref riferimento al cliente richiedente i messaggi, che otterr
	 * i messaggi attraverso il meccanismo della callback
	 * @throws RemoteException
	 */
	public void read(INewsgroupClient client_ref)throws RemoteException;
	
	/**
	 * Metodo che permette la lettura di un messaggio dato il suo ID univoco
	 * @param client_ref riferimento al client per la callback
	 * @param ID Stringa rappresentante l'ID del messaggio di interesse
	 * @throws RemoteException
	 */
	public void readIDMsg(INewsgroupClient client_ref,String ID)throws RemoteException;
	
	/**
	 * Metodo che restituisce i messaggi risposta a un messaggio di cui si conosce l'ID
	 * @param client_ref riferimento al client remoto per la callback
	 * @param ID Stringa contenente l'ID del messaggio di cui si cercano le risposte
	 * @throws RemoteException
	 */
	public void readResponse(INewsgroupClient client_ref,String ID)throws RemoteException;
	
	/**
	 * Metodo per scrivere in remoto un messaggio
	 * sulla bacheca elettronica. 
	 * La comunicazione col client avviene tramite callback
	 * @param client mittente del messaggio
	 * @param obj oggetto del messaggio
	 * @param body corpo del messaggio
	 * @param father messaggio di cui mess  risposta, se mess non era una 
	 * 			risposta il valore di father  a null
	 * @param client_ref riferimento al client remoto
	 * @throws RemoteException
	 */
	public void writeMsg(Person client,String obj,String body,
			Msg father,INewsgroupClient client_ref)throws RemoteException;
	
	/**
	 * Metodo per scrivere in remoto un messaggio
	 * sulla bacheca elettronica comunicando anche la data. 
	 * La comunicazione col client avviene tramite callback
	 * @param client mittente del messaggio
	 * @param time data del messaggio
	 * @param obj oggetto del messaggio
	 * @param body corpo del messaggio
	 * @param father messaggio di cui mess  risposta, se mess non era una 
	 * 			risposta il valore di father  a null
	 * @param client_ref riferimento al client remoto
	 * @throws RemoteException
	 */
	public void writeMsg(Person client,Date time,String obj,String body,
			Msg father,INewsgroupClient client_ref)throws RemoteException;
	
	/**
	 * Metodo che ritorna il nome del server
	 * @return nome del server
	 * @throws RemoteException
	 */
	public String getName()throws RemoteException;
	

}
